#!/bin/bash
GROUP=$1
FILE=$2
groupadd $GROUP
mkdir /home/$GROUP
#awk兩旁的是反單引號，就是鍵盤數字鍵1左邊的符號鍵
for i in `awk -F: '{print $1}' $FILE `
do
  #-m選項，要求建立家目錄
  useradd -g $GROUP -d /home/$GROUP/$i -m $i 
  #設定使用者的密碼
  grep "\<$i\>" $FILE |chpasswd
  #設定強迫使用者一登入便得修改密碼
  chage -d 0 $i 
  #設定User Quota policy
  #Block limit:10MB(10240K) - 12MB(12288K)
  #inode limit:80 - 100
  setquota -u $i 10240 12288 80 100 /home
done


